<!--====== Start Footer ======-->
<footer class="footer-area bg-primary-light">
    <?php if($bs->top_footer_section == 1): ?>
        <div class="footer-top pt-120 pb-90">
            <div class="container">
                <div class="row gx-xl-5 justify-content-between">
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="footer-widget" data-aos="fade-up" data-aos-delay="100">
                            <div class="navbar-brand">
                                <a href="<?php echo e(route('front.index')); ?>">
                                    <img class="lazyload" data-src="<?php echo e(asset('assets/front/img/' . $bs->footer_logo)); ?>"
                                        alt="">
                                </a>
                            </div>
                            <p><?php echo e($bs->footer_text); ?></p>
                        </div>
                    </div>
                    <?php
                        $ulinks = App\Models\Ulink::where('language_id', $currentLang->id)
                            ->orderby('id', 'desc')
                            ->get();
                    ?>
                    <div class="col-xl-2 col-lg-2 col-md-3 col-sm">
                        <div class="footer-widget" data-aos="fade-up" data-aos-delay="200">
                            <h5><?php echo e($bs->useful_links_title); ?></h5>
                            <ul class="footer-links">
                                <?php $__currentLoopData = $ulinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ulink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e($ulink->url); ?>"><?php echo e($ulink->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="footer-widget" data-aos="fade-up" data-aos-delay="400">
                            <h5><?php echo e(__('Contact Us')); ?></h5>
                            <ul class="info-list">
                                <li>
                                    <i class="fal fa-map-marker-alt"></i>
                                    <?php
                                        $addresses = explode(PHP_EOL, $be->contact_addresses);
                                    ?>
                                    <span>
                                        <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($address); ?>

                                            <?php if(!$loop->last): ?>
                                                |
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </span>
                                </li>

                                <li>
                                    <i class="fal fa-phone-plus"></i>
                                    <div>
                                        <?php
                                            $phones = explode(',', $be->contact_numbers);
                                        ?>
                                        <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="tel:<?php echo e($phone); ?>" title="<?php echo e($phone); ?>">
                                                <?php echo e($phone); ?>

                                            </a>
                                            <?php if(!$loop->last): ?>
                                                ,
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <i class="fal fa-envelope"></i>
                                    <div>
                                        <?php
                                            $mails = explode(',', $be->contact_mails);
                                        ?>
                                        <?php $__currentLoopData = $mails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="mailto:<?php echo e($mail); ?>" title="<?php echo e($mail); ?>">
                                                <?php echo e($mail); ?>

                                            </a>
                                            <?php if(!$loop->last): ?>
                                                ,
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="footer-widget" data-aos="fade-up" data-aos-delay="300">
                            <h5><?php echo e($bs->newsletter_title); ?></h5>
                            <p class="lh-1 mb-20"><?php echo e($bs->newsletter_subtitle); ?></p>
                            <div class="newsletter-form">
                                <form id="newsletterForm" class="subscribeForm" action="<?php echo e(route('front.subscribe')); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <input class="form-control radius-sm"
                                            placeholder="<?php echo e(__('Enter Your Email')); ?>" type="email" name="email"
                                            required="" autocomplete="off">
                                        <button class="newsletter-btn btn btn-md btn-primary radius-sm no-animation"
                                            type="submit"><i class="fal fa-paper-plane"></i></button>
                                    </div>
                                    <p id="erremail" class="text-danger mb-0 err-email"></p>
                                    <div class="form-group mt-3 ">
                                        <?php if($bs->is_recaptcha == 1): ?>
                                            <div class="d-block mb-4">
                                                <?php echo NoCaptcha::renderJs(); ?>

                                                <?php echo NoCaptcha::display(); ?>


                                                <p
                                                    id="errg-recaptcha-response"class=" text-danger err-g-recaptcha-response mt-2">
                                                </p>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if($bs->copyright_section == 1): ?>
        <div class="copy-right-area border-top">
            <div class="container">
                <div class="copy-right-content">
                    <div class="social-link justify-content-center mb-2">
                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($social->url); ?>" target="_blank" title="instagram"><i
                                    class="<?php echo e($social->icon); ?>"></i></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                    <span>
                        <?php echo replaceBaseUrl($bs->copyright_text); ?>

                    </span>
                </div>
            </div>
        </div>
    <?php endif; ?>
</footer>
<!--====== End Footer ======-->
<?php /**PATH /Users/samiulalimpratik/Sites/businesso/businesso/resources/views/front/partials/footer.blade.php ENDPATH**/ ?>