<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_home_sections', function (Blueprint $table) {
            $table->integer('slider_posts')->unsigned()->default(0);
            $table->integer('latest_posts')->unsigned()->default(0);
            $table->integer('popular_posts')->unsigned()->default(0);
            $table->integer('newsletter')->unsigned()->default(0);
            $table->integer('gallery')->unsigned()->default(0);
            $table->integer('featured_category_posts')->unsigned()->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_home_sections', function (Blueprint $table) {
            $table->dropColumn('slider_posts');
            $table->dropColumn('latest_posts');
            $table->dropColumn('popular_posts');
            $table->dropColumn('newsletter');
            $table->dropColumn('gallery');
            $table->dropColumn('featured_category_posts');
        });
    }
};
