<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_gallery_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('language_id')->nullable(false);
            $table->unsignedInteger('user_id')->nullable(false);
            $table->string('item_type', 255)->collation('utf8mb4_unicode_ci');
            $table->string('image', 255)->collation('utf8mb4_unicode_ci');
            $table->string('video_link', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('title', 255)->collation('utf8mb4_unicode_ci');
            $table->mediumInteger('serial_number')->unsigned();
            $table->tinyInteger('is_featured')
                ->default(0)
                ->comment('0 => will not appear in home page, 1 => will appear in home page');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_gallery_items');
    }
};
